var ie = (navigator.appName.indexOf("Microsoft Internet Explorer") > -1);
var blurFocus = true;

var moreBox = false;
var audioClip = false;
var autoPlay = true;
var popAudioClip = false;
var videoClip = false;
var popVideoClip = false;
var soundFX = false;
var mediaType = "flash";

var videoWidth = 320;
var videoHeight = 240;

var audioButtonCallbackId = null;
var videoButtonCallbackId = null;
var moreButtonCallbackId = null;
var navigateEventCallbackId = null;

var moreTimerId = null;

function initializePage()
{
	audioButtonCallbackId = toolbarAPI.registerEvent("audiobuttonclick","onAudioClick", window);
	videoButtonCallbackId = toolbarAPI.registerEvent("videobuttonclick","onVideoClick", window);
	moreButtonCallbackId = toolbarAPI.registerEvent("morebuttonclick","onMoreClick", window);
	navigateEventCallbackId = toolbarAPI.registerEvent("navigate","onNavigate", window);
	
	if (moreBox)
	{
		toolbarAPI.executeMethod("enableButton","MoreButton");
		if (videoClip && (getLayerRef("VideoLayer") != null))
		{
			moreTimerId = setInterval("moreAdjust()",1000);
		}
	}
	if (audioClip)
	{
		toolbarAPI.executeMethod("enableButton","AudioButton");
	}
	if (videoClip)
	{
		toolbarAPI.executeMethod("enableButton","VideoButton");
	}
	
	// Set the document title to be the same as the node title
	document.title = nodeAPI.getNodeTitle();
	
	hideShowMediaLayers();
	
	// if initPage() is defined in the page,
	// then call it.
	if (window.initPage)
	{
		window.initPage();
	}
	
	if (audioClip && !(window.pagePlaysMedia==true))
	{
		playClip("AudioClip");
	}
	else if (videoClip && !(window.pagePlaysMedia==true))
	{
		playClip("VideoClip");
	}
	
	nodeAPI.setNodeAttempted(true);
}

function terminatePage()
{
	toolbarAPI.unregisterEvent(audioButtonCallbackId);
	toolbarAPI.unregisterEvent(videoButtonCallbackId);
	toolbarAPI.unregisterEvent(moreButtonCallbackId);
	toolbarAPI.unregisterEvent(navigateEventCallbackId);
	
	if (moreBox)
	{
		toolbarAPI.executeMethod("disableButton","MoreButton");
	}
	if (audioClip)
	{
		toolbarAPI.executeMethod("disableButton","AudioButton");
	}
	if (videoClip)
	{
		toolbarAPI.executeMethod("disableButton","VideoButton");
	}
}

function hideShowMediaLayers()
{		
	// Show the audio layer if there is a flash
	// audio or pop audio clip.
	if ((audioClip || popAudioClip || soundFX) && (mediaType.toLowerCase() == "flash" || mediaType.toLowerCase() == "windowsmedia7"))
	{
		showLayer("AudioLayer");
	}
}

function onAudioClick()
{
  // Place code here to play the audio.
  stopClip("AudioClip");
  playClip("AudioClip");
}

function onVideoClick()
{
  // Place code here to play the video.
  showLayer("VideoLayer");
  playClip("VideoClip");
}

function onMoreClick()
{
  // Place code here to show the more box.
  toggleLayerVisibility("MoreLayer");
  layerToFront("MoreLayer");
}

function onNavigate()
{

}

function closeMoreBox()
{
	hideLayer("MoreLayer");
}

function moreAdjust()
{
	if (getLayerVisibility("MoreLayer"))
	{
		hideLayer("VideoLayer");
	}
	else
	{
		showLayer("VideoLayer");
	}
}

function appendToFunction(objFunc, txtJS)
{
	var intIndexStart = 0;
	var intIndexEnd = 0;
	var txtFunc = "";
	if (objFunc == null) 
	{
		txtFunc = "new function () {}"
	}
	else
	{
		txtFunc = objFunc.toString();
	}
	intIndexStart = txtFunc.indexOf("{")+1;
	intIndexEnd = txtFunc.lastIndexOf("}");
	return new Function ("",txtFunc.slice(intIndexStart,intIndexEnd) + "\n" + txtJS);
}

function getFilenameLessExtension(win)
{
	if (!win) win = window;

	var strUrl = win.document.URL.replace(/\\/g,"/");
	return strUrl.slice(strUrl.lastIndexOf("/")+1,strUrl.lastIndexOf("."));
}

function getFilename(win)
{
	if (!win) win = window;

	var strUrl = win.document.URL.replace(/\\/g,"/");
	return strUrl.slice(strUrl.lastIndexOf("/")+1,strUrl.length);
}

